#ifndef __gxframework_viewport_h__
	#define __gxframework_viewport_h__

#include "shared.h"

namespace Gx
{
	class GXFRAMEWORK_DECLSPEC Viewport
	{
	public:
		Viewport(unsigned int width, unsigned int height);

		float getAspectRatio() const {
			return static_cast<float>(m_width) / static_cast<float>(m_height);
		}

		unsigned int getWidth() const {
			return m_width;
		}

		unsigned int getHeight() const {
			return m_height;
		}

	private:
		unsigned int m_width;
		unsigned int m_height;
	};
}

#endif // ~__gxframework_viewport_h__
